using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace BreadAndCheese {
    /// <summary>
    /// To jest gwny typ Twojej gry.
    /// </summary>
    public class BreadAndCheeseGame : Microsoft.Xna.Framework.Game {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        // wiat gry
        Texture2D cheeseTexture;
        Rectangle cheeseRectangle;

        // Ustawienia ekranu
        float displayWidth;
        float displayHeight;

        // Szybko sera
        float cheeseWidthFactor = 0.05f;
        float cheeseTicksToCrossScreen = 200.0f;

        float cheeseX;
        float cheeseXSpeed;
        float cheeseY;
        float cheeseYSpeed;

        void scaleSprites() {
            cheeseRectangle.Width = (int) ((displayWidth * cheeseWidthFactor) + 0.5f);

            float aspectRatio = (float) cheeseTexture.Width / cheeseTexture.Height;
            cheeseRectangle.Height = (int) ((cheeseRectangle.Width / aspectRatio) + 0.5f);

            cheeseX = 0;
            cheeseY = 0;
            cheeseXSpeed = displayWidth / cheeseTicksToCrossScreen;
            cheeseYSpeed = cheeseXSpeed;
        }

        public BreadAndCheeseGame() {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Umoliwia ewentualn inicjalizacj przed uruchomieniem waciwej gry.
        /// W tym miejscu mona odnale wszystkie wymagane zasoby i zaadowa treci
        /// related content. Wywoanie metody base.Initialize spowoduje przeszukanie wszystkich komponentw
        /// i ich inicjalizacj.
        /// </summary>
        protected override void Initialize() {
            displayWidth = GraphicsDevice.Viewport.Width;
            displayHeight = GraphicsDevice.Viewport.Height;

            base.Initialize();
        }

        /// <summary>
        /// Metoda LoadContent jest wywoywana tylko raz dla caej gry i jako taka jest waciwym miejscem
        /// dla kodu adujcego tre.
        /// </summary>
        protected override void LoadContent() {
            // Tworzy nowy obiekt klasy SpriteBatch, ktrego mona uywa do rysowania tekstur.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            cheeseTexture = Content.Load<Texture2D > ("Images/Cheese");

            scaleSprites();

        }

        /// <summary>
        /// Metoda UnloadContent jest wywoywana tylko raz dla caej gry i jako taka jest waciwym miejscem
        /// dla kodu usuwajcego ca tre z pamici.
        /// </summary>
        protected override void UnloadContent() {
            // TODO: Naley usun ca tre, ktr nie zarzdza ContentManager.
        }

        /// <summary>
        /// Umoliwia grze wykonywanie logiki zwizanej z aktualizacj wiata gry,
        /// sprawdzaniem kolizji, pobieraniem danych wejciowych czy odtwarzaniem dwikw.
        /// </summary>
        /// <param name="gameTime">Udostpnia wartoci reprezentujce biecy czas.</param>
        protected override void Update(GameTime gameTime) {
            // Pozwala opuci gr
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            cheeseX = cheeseX + cheeseXSpeed;
            cheeseY = cheeseY + cheeseYSpeed;

            if (cheeseX + cheeseRectangle.Width >= displayWidth) {
                cheeseXSpeed = cheeseXSpeed * -1;
            }

            if (cheeseX <= 0) {
                cheeseXSpeed = cheeseXSpeed * -1;
            }

            if (cheeseY + cheeseRectangle.Height >= displayHeight) {
                cheeseYSpeed = cheeseYSpeed * -1;
            }

            if (cheeseY <= 0) {
                cheeseYSpeed = cheeseYSpeed * -1;
            }

            cheeseRectangle.X = (int) (cheeseX + 0.5f);
            cheeseRectangle.Y = (int) (cheeseY + 0.5f);

            base.Update(gameTime);
        }

        /// <summary>
        /// Ta metoda jest wywoywana w momencie, w ktrym gra musi narysowa swj wiat.
        /// </summary>
        /// <param name="gameTime">Udostpnia wartoci reprezentujce biecy czas.</param>
        protected override void Draw(GameTime gameTime) {
            GraphicsDevice.Clear(Color.CornflowerBlue);

            spriteBatch.Begin();

            spriteBatch.Draw(cheeseTexture, cheeseRectangle, Color.White);

            spriteBatch.End();

            base.Draw(gameTime);
        }
    }
}
